-- Items Tracker Database Schema
-- Version: 1
-- Database: items_tracker_{mode}.db
-- Managed by: ItemsDatabaseManager (PySide6) and ItemsDatabaseManagerWx (wxPython)
--
-- This schema defines the structure for the items tracker database,
-- which stores user's stash inventory, hideout levels, and favorite items.

-- ============================================================================
-- TABLE: item_counts
-- Purpose: User's stash inventory (HAVE counts for each item)
-- ============================================================================
CREATE TABLE IF NOT EXISTS item_counts (
    item_id TEXT PRIMARY KEY,
    have_count INTEGER DEFAULT 0,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- TABLE: hideout_stations
-- Purpose: Current level of each hideout station (affects item needs calculation)
-- ============================================================================
CREATE TABLE IF NOT EXISTS hideout_stations (
    station_id TEXT PRIMARY KEY,
    station_name TEXT,
    current_level INTEGER DEFAULT 0,
    max_level INTEGER DEFAULT 3,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- TABLE: favorite_items
-- Purpose: User-favorited items for quick access
-- CRITICAL: Column names are 'added_at' and 'added_by' (NOT 'favorited_at')
-- ============================================================================
CREATE TABLE IF NOT EXISTS favorite_items (
    item_id TEXT PRIMARY KEY,
    item_name TEXT,
    added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    added_by TEXT
);

-- ============================================================================
-- TABLE: change_log
-- Purpose: Real-time change events for IPC (Inter-Process Communication)
-- Used to synchronize changes between main app and quest tree processes
-- ============================================================================
CREATE TABLE IF NOT EXISTS change_log (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    table_name TEXT NOT NULL,
    record_id TEXT NOT NULL,
    change_type TEXT NOT NULL,  -- INSERT, UPDATE, DELETE
    changed_by TEXT NOT NULL,   -- app_identifier
    change_data TEXT,           -- JSON
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- ============================================================================
-- TABLE: settings
-- Purpose: Application settings in key-value format
-- ============================================================================
CREATE TABLE IF NOT EXISTS settings (
    key TEXT PRIMARY KEY,
    value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- INDEXES
-- ============================================================================
CREATE INDEX IF NOT EXISTS idx_change_log_timestamp ON change_log(timestamp);
CREATE INDEX IF NOT EXISTS idx_change_log_app ON change_log(changed_by, timestamp);

-- ============================================================================
-- SCHEMA VERSION
-- Store schema version in settings table for migration tracking
-- ============================================================================
INSERT OR IGNORE INTO settings (key, value) VALUES ('schema_version', '1');
