-- Main Config Database Schema
-- Version: 1
-- Database: main_config_{mode}.db
-- Managed by: MainConfigManager (PySide6)
--
-- This schema defines the structure for the main config database,
-- which stores trader levels and player level settings.

-- ============================================================================
-- TABLE: trader_levels
-- Purpose: Current level for each trader (Prapor, Therapist, Skier, etc.)
-- Levels: 1-4 (LL1, LL2, LL3, LL4)
-- ============================================================================
CREATE TABLE IF NOT EXISTS trader_levels (
    trader_id TEXT PRIMARY KEY,
    trader_name TEXT,
    current_level INTEGER DEFAULT 1,
    max_level INTEGER DEFAULT 4,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- TABLE: player_level
-- Purpose: Current player level (1-79)
-- Note: Single-row table (id always = 1)
-- ============================================================================
CREATE TABLE IF NOT EXISTS player_level (
    id INTEGER PRIMARY KEY CHECK (id = 1),
    level INTEGER DEFAULT 1,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- TABLE: change_log
-- Purpose: Real-time change events for IPC (Inter-Process Communication)
-- Used to synchronize changes between quest tree and other processes
-- ============================================================================
CREATE TABLE IF NOT EXISTS change_log (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    table_name TEXT NOT NULL,
    record_id TEXT NOT NULL,
    change_type TEXT NOT NULL,  -- INSERT, UPDATE, DELETE
    changed_by TEXT NOT NULL,   -- app_identifier
    change_data TEXT,           -- JSON
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- ============================================================================
-- TABLE: settings
-- Purpose: Application settings in key-value format
-- Stored Settings:
--   - 'schema_version': Database schema version number (e.g., '1')
--   - 'player_faction': Player faction ("USEC" or "BEAR", default "USEC")
-- ============================================================================
CREATE TABLE IF NOT EXISTS settings (
    key TEXT PRIMARY KEY,
    value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_by TEXT
);

-- ============================================================================
-- INDEXES
-- ============================================================================
CREATE INDEX IF NOT EXISTS idx_change_log_timestamp ON change_log(timestamp);
CREATE INDEX IF NOT EXISTS idx_change_log_app ON change_log(changed_by, timestamp);

-- ============================================================================
-- SCHEMA VERSION
-- Store schema version in settings table for migration tracking
-- ============================================================================
INSERT OR IGNORE INTO settings (key, value) VALUES ('schema_version', '1');

-- ============================================================================
-- INITIAL DATA
-- Initialize player_level table and default settings
-- ============================================================================
INSERT OR IGNORE INTO player_level (id, level) VALUES (1, 1);
INSERT OR IGNORE INTO settings (key, value) VALUES ('player_faction', 'USEC');
